// ===== DEFAULT CONFIGURATION PARAMETERS =====
const DEFAULT_SKILL_NAME = "Spear";
const DEFAULT_MASTERY_LEVEL = 69;
const DEFAULT_SKILL_MODIFIER = 0;
const DEFAULT_ZONE_DIE = "1d8";
const DEFAULT_LOCATION_DIE = "1d10";
const DEFAULT_IMPACT_DIE = "1d8";
const DEFAULT_IMPACT_MODIFIER = 5;
const DEFAULT_QUALIFIER = "P";
// ============================================

// Create and display the dialog
new Dialog({
  title: "HarnMaster Skill Check",
  content: `
    <form>
      <div class="form-group">
        <label>Skill Name:</label>
        <input type="text" id="skill-name" name="skill-name" value="${DEFAULT_SKILL_NAME}" />
      </div>
      <div class="form-group">
        <label>Mastery Level (ML):</label>
        <input type="number" id="mastery-level" name="mastery-level" value="${DEFAULT_MASTERY_LEVEL}" min="1" max="100" />
      </div>
      <div class="form-group">
        <label>Skill Test Modifier:</label>
        <input type="number" id="skill-modifier" name="skill-modifier" value="${DEFAULT_SKILL_MODIFIER}" />
      </div>
      <hr>
      <h3>Damage Roll Configuration</h3>
      <div class="form-group">
        <label>Zone Die:</label>
        <input type="text" id="zone-die" name="zone-die" value="${DEFAULT_ZONE_DIE}" />
      </div>
      <div class="form-group">
        <label>Location Die:</label>
        <input type="text" id="location-die" name="location-die" value="${DEFAULT_LOCATION_DIE}" />
      </div>
      <div class="form-group">
        <label>Impact Die:</label>
        <input type="text" id="impact-die" name="impact-die" value="${DEFAULT_IMPACT_DIE}" />
      </div>
      <div class="form-group">
        <label>Impact Modifier:</label>
        <input type="number" id="impact-modifier" name="impact-modifier" value="${DEFAULT_IMPACT_MODIFIER}" />
      </div>
      <div class="form-group">
        <label>Qualifier:</label>
        <input type="text" id="qualifier" name="qualifier" value="${DEFAULT_QUALIFIER}" maxlength="2" />
      </div>
    </form>
  `,
  buttons: {
    roll: {
      icon: '<i class="fas fa-dice-d20"></i>',
      label: "Roll",
      callback: async (html) => {
        // Get values from the dialog
        const skillName = html.find('[name="skill-name"]').val();
        const masteryLevel = parseInt(html.find('[name="mastery-level"]').val());
        const skillModifier = parseInt(html.find('[name="skill-modifier"]').val());
        const zoneDie = html.find('[name="zone-die"]').val();
        const locationDie = html.find('[name="location-die"]').val();
        const impactDie = html.find('[name="impact-die"]').val();
        const impactModifier = parseInt(html.find('[name="impact-modifier"]').val());
        const qualifier = html.find('[name="qualifier"]').val();
        
        // Calculate effective mastery level
        const effectiveML = masteryLevel + skillModifier;
        
        // Make the initial skill check
        const skillRoll = await new Roll("1d100").evaluate({async: true});
        const rollResult = skillRoll.total;
        const isSuccess = rollResult <= effectiveML;
        
        // Check if it's a critical (ends in 0 or 5)
        const lastDigit = rollResult % 10;
        const isCritical = (lastDigit === 0 || lastDigit === 5);
        
        // Determine result type
        let resultText = "";
        let resultColor = "";
        
        if (isSuccess && isCritical) {
          resultText = "CRITICAL SUCCESS";
          resultColor = "blue";
        } else if (isSuccess) {
          resultText = "SUCCESS";
          resultColor = "green";
        } else if (!isSuccess && isCritical) {
          resultText = "CRITICAL FAILURE";
          resultColor = "darkred";
        } else {
          resultText = "FAILURE";
          resultColor = "red";
        }
        
        // Create the initial chat message
        let chatContent = `
          <div class="harnmaster-skill-check">
            <h3>${skillName}</h3>
            <p><strong>ML:</strong> ${masteryLevel}</p>
            ${skillModifier !== 0 ? `<p><strong>Modifier:</strong> ${skillModifier > 0 ? '+' : ''}${skillModifier}</p>` : ''}
            <p><strong>EML:</strong> ${effectiveML}</p>
            <p><strong>Roll:</strong> ${rollResult}</p>
            <p><strong>Result:</strong> <span style="color: ${resultColor}; font-weight: bold; ${isCritical ? 'font-size: 18px;' : ''}">
              ${resultText}
            </span></p>
          </div>
        `;
        
        // If successful, add the damage roll button
        if (isSuccess) {
          chatContent += `
            <button class="harn-damage-roll" data-zone="${zoneDie}" data-location="${locationDie}" data-impact="${impactDie}" data-impact-mod="${impactModifier}" data-qualifier="${qualifier}" style="margin-top: 10px;">
              Roll for Damage
            </button>
          `;
        }
        
        // Display the roll in chat
        await skillRoll.toMessage({
          speaker: ChatMessage.getSpeaker(),
//          flavor: `HarnMaster Skill Check: ${skillName}`,
          content: chatContent
        });
        
        // Add click listener for the damage button if success
        if (isSuccess) {
          Hooks.once("renderChatMessage", (message, html) => {
            html.find(".harn-damage-roll").click(async (event) => {
              const button = $(event.currentTarget);
              const zoneDie = button.data("zone");
              const locationDie = button.data("location");
              const impactDie = button.data("impact");
              const impactMod = button.data("impact-mod");
              const qual = button.data("qualifier");
              
              // Roll all three dice and display them
              const zoneRoll = await new Roll(zoneDie).evaluate({async: true});
              await zoneRoll.toMessage({
                speaker: ChatMessage.getSpeaker(),
                flavor: "Zone Roll"
              });
              
              const locationRoll = await new Roll(locationDie).evaluate({async: true});
              await locationRoll.toMessage({
                speaker: ChatMessage.getSpeaker(),
                flavor: "Location Roll"
              });
              
              const impactRoll = await new Roll(`${impactDie} + ${impactMod}`).evaluate({async: true});
              await impactRoll.toMessage({
                speaker: ChatMessage.getSpeaker(),
                flavor: "Impact Roll"
              });
              
              // Format the summary output
              const damageContent = `
                <div class="harnmaster-damage">
                  <h3>Damage Summary</h3>
                  <p style="font-size: 16px; font-weight: bold;">
                    ZN: ${zoneRoll.total} &nbsp;&nbsp;
                    LN: ${locationRoll.total} &nbsp;&nbsp;
                    IMP: ${impactRoll.total}${qual}
                  </p>
                </div>
              `;
              
              // Send damage summary to chat
              ChatMessage.create({
                speaker: ChatMessage.getSpeaker(),
                content: damageContent
              });
            });
          });
        }
      }
    },
    cancel: {
      icon: '<i class="fas fa-times"></i>',
      label: "Cancel"
    }
  },
  default: "roll"
}).render(true);