// ===== DEFAULT CONFIGURATION PARAMETERS =====
const DEFAULT_SKILL_NAME = "Climbing";
const DEFAULT_MASTERY_LEVEL = 50;
const DEFAULT_SKILL_MODIFIER = 0;
// ============================================

// Create and display the dialog
new Dialog({
  title: "HarnMaster Skill Check",
  content: `
    <form>
      <div class="form-group">
        <label>Skill Name:</label>
        <input type="text" id="skill-name" name="skill-name" value="${DEFAULT_SKILL_NAME}" />
      </div>
      <div class="form-group">
        <label>Mastery Level (ML):</label>
        <input type="number" id="mastery-level" name="mastery-level" value="${DEFAULT_MASTERY_LEVEL}" min="1" max="100" />
      </div>
      <div class="form-group">
        <label>Skill Test Modifier:</label>
        <input type="number" id="skill-modifier" name="skill-modifier" value="${DEFAULT_SKILL_MODIFIER}" />
      </div>
    </form>
  `,
  buttons: {
    roll: {
      icon: '<i class="fas fa-dice-d20"></i>',
      label: "Roll",
      callback: async (html) => {
        // Get values from the dialog
        const skillName = html.find('[name="skill-name"]').val();
        const masteryLevel = parseInt(html.find('[name="mastery-level"]').val());
        const skillModifier = parseInt(html.find('[name="skill-modifier"]').val());
        
        // Calculate effective mastery level
        const effectiveML = masteryLevel + skillModifier;
        
        // Make the skill check
        const skillRoll = await new Roll("1d100").evaluate({async: true});
        const rollResult = skillRoll.total;
        const isSuccess = rollResult <= effectiveML;
        
        // Check if it's a critical (ends in 0 or 5)
        const lastDigit = rollResult % 10;
        const isCritical = (lastDigit === 0 || lastDigit === 5);
        
        // Determine result type
        let resultText = "";
        let resultColor = "";
        
        if (isSuccess && isCritical) {
          resultText = "CRITICAL SUCCESS";
          resultColor = "gold";
        } else if (isSuccess) {
          resultText = "SUCCESS";
          resultColor = "green";
        } else if (!isSuccess && isCritical) {
          resultText = "CRITICAL FAILURE";
          resultColor = "darkred";
        } else {
          resultText = "FAILURE";
          resultColor = "red";
        }
        
        // Create the chat message
        let chatContent = `
          <div class="harnmaster-skill-check">
            <h3>${skillName}</h3>
            <p><strong>Base ML:</strong> ${masteryLevel}</p>
            ${skillModifier !== 0 ? `<p><strong>Modifier:</strong> ${skillModifier > 0 ? '+' : ''}${skillModifier}</p>` : ''}
            <p><strong>EML:</strong> ${effectiveML}</p>
            <p><strong>Roll:</strong> ${rollResult}</p>
            <p><strong>Result:</strong> <span style="color: ${resultColor}; font-weight: bold; ${isCritical ? 'font-size: 18px;' : ''}">
              ${resultText}
            </span></p>
          </div>
        `;
        
        // Display the roll in chat
        await skillRoll.toMessage({
          speaker: ChatMessage.getSpeaker(),
//        flavor: `HarnMaster Skill Check: ${skillName}`,
          content: chatContent
        });
      }
    },
    cancel: {
      icon: '<i class="fas fa-times"></i>',
      label: "Cancel"
    }
  },
  default: "roll"
}).render(true);